
-------------------------------------------------------------------------------------------
--   File:			CaptureAnim*.MS
--   Description:	A utility for capturing animation off bone hierarchies onto CAT rigs
--   By:			Philip Taylor 			phil@catoolkit.com
--   Created:		26/08/04
-------------------------------------------------------------------------------------------

filein "CATMacroUtilFunctions.ms"

global gXmlIO, rCATRigMapping, rCaptureAnim, mappinglayerData;

global lvops  --The ListViewOps struct definition found in <3dsmax>\stdplugs\stdscripts\NET_ListViewWrapper.ms
 
mappinglayerData = attributes mappinglayerDataDef 
(
	parameters main
	(
		mappinglayer type:#string 
	)
)


rollout rCATRigMapping ~RCATRIGMAPPING_CAPTION~ width:620 height:340
(
	-- Predeclared function names
	local MapNodes, GetMappedNode, CollectSourceNodes, FindNodes, IsChildOf, FindMostChildNodes, FindMostParentNodes, RemoveNonChildNodes;

	local cur_width=356, src_width=230, sry = 0, capture_col = 1, enable_debug = false;
	local rolls=0;

	-- Node level drag & drop variables
	local in_drop = false, drag_node, drop_node

--	activeXControl ilLv "{2C247F23-8591-11D1-B16A-00C0F0283628}" height:0 width:0
--	activeXControl lvSource "MSComctlLib.ListViewCtrl" pos:[5, 5] width:src_width				height:290	-- source objects listview
--	activeXControl lvCATRig "MSComctlLib.ListViewCtrl" pos:[src_width+5, 5] width:cur_width 	height:290	-- target objects listview		  			
	dotNetControl lvSource  "ListView" pos:[005, 005]       width: src_width			height: 290	-- source objects listview
	dotNetControl lvCATRig "ListView" pos:[src_width+5, 5] width:(src_width + 126) 	height: 290	-- current objects listview		  			
		
	fn getHitNode ctrl =
	(
		local p = getCursorPos ctrl
		local calib = 15
		ctrl.HitTest ((p.x-2)*calib) ((p.y-2)*calib)
	)

	on rCATRigMapping rolledUp state do
	(
		rolls = rolls + 1;
		if rolls==2 and (maxversion())[1]<8000 then( return OK; )
		
		if state then sry = 300 else sry = 0
		
		rCaptureAnim.height = sry + 175
		rCaptureAnim.srRollouts.height = sry + 30
		
		rCaptureAnim.pbStatus.pos = [130, sry + 152]
		rCaptureAnim.lblStatus.pos = [5, sry + 152]
	)
	
	on rCATRigMapping open do
	(		
/*		rolls = 0;
		-- set the up/down button images
		try (
			local icon_dir = getDir #ui
			ilLv.imageHeight = ilLv.imageWidth = 4
			-- for some insane reason, this line enables indenting to work on listviews!
			ilLv.listImages.add 1 "" (loadPicture (icon_dir + "\\icons\\tvObj.ico"))
			lvSource.smallIcons = lvCATRig.smallIcons = ilLv
		) catch ()
*/

		-- Initialize the ListView controls
		local l_widthA = (rCATRigMapping.cur_width/2 - 2)
		local l_widthB = (rCATRigMapping.src_width - 4)
		lvops.InitListView lvCATRig pInitColumns:#(~TARGET_CATRIG~, ~CAPTURE_NODE~) pAllowReorder:false	pAllowDrop: true pInitColWidths:#(l_widthA,l_widthA ) 	pLabelEdit:false
		lvops.InitListView lvSource  pInitColumns:#(~SOURCE_NODES~)                 pAllowReorder:false	pAllowDrop: true pInitColWidths:#(l_widthB)          		pLabelEdit:false
				
		local sortOrder = dotNetClass "System.Windows.Forms.SortOrder"
		lvCATRig.Sorting = sortOrder.None;
		lvSource.Sorting = sortOrder.None;
		
		
		lvCATRig.hideSelection = false
		lvSource.hideSelection = false
		
		lvops.InitImageList lvSource #("$maxSysIcons/tvObj.ico") pSize: 5 
		lvops.InitImageList lvCATRig #("$maxSysIcons/tvObj.ico") pSize: 5
	)
	
	fn findmax vec = 
	(
		if (abs vec.x) > (abs vec.y) and (abs vec.x) > (abs vec.z) then 
			if vec.x > 0.0f then return [1.0, 0.0, 0.0] else return [-1.0, 0.0, 0.0];
		if (abs vec.y) > (abs vec.x) and (abs vec.y) > (abs vec.z) then
			if vec.y > 0.0f then return [0.0, 1.0, 0.0] else return [0.0, -1.0, 0.0];
		if (abs vec.z) > (abs vec.x) and (abs vec.z) > (abs vec.y) then
			if vec.z > 0.0f then return [0.0, 0.0, 1.0] else return [0.0, 0.0, -1.0];
	)
	
	fn FindOrthonormalMatrix &tm =
	(
		tm.row1 = findmax tm.row1
		tm.row2 = findmax tm.row2
		tm.row3 = findmax tm.row3
	)
	
	fn SetAlignmentTM index alignment_tm =
	(
	--	if (index==1) or (not rCaptureAnim.chkInheritRoot.checked) then
	--		 rCaptureAnim.offset_tms[index] = alignment_tm;
	--	else rCaptureAnim.offset_tms[index] = alignment_tm * (Inverse rCaptureAnim.offset_tms[1]);
	)
	
	---------------------------------------------------------------------------
	-- 
	fn DeleteAllSourceNodes = 
	(
		-- Now remove the Capture layer
		try(
			if rCaptureAnim.targetLayerInfo != undefined then
			(
				if rCaptureAnim.targetLayerInfo.catparent.numlayers == 1 then
					rCaptureAnim.targetLayerInfo.catparent.catmode = 0;
				rCaptureAnim.targetLayerInfo.catparent.RemoveLayer rCaptureAnim.targetLayerInfo.layerindex;
				rCaptureAnim.targetLayerInfo = undefined;
			)
			
			local lvItems = lvops.GetLvItems lvSource;
			for i=1 to lvItems.count do
			(
				local lvn = lvItems[i];
				if lvn.tag != undefined then
				(
					local node = lvn.tag.value;
					if (classof node)== Biped_Object then(
						-- if we delete one biped node then the rest get deleted anyway
						delete node;
						return OK;
					)	
					if node!= undefined and node != "" then
						delete node;
				)
			)
		)
		catch()
		
	--	gc();
	)
	fn HilightSelection = 
	(
		local itemsCATRig = lvops.GetLvItems lvCATRig
		local itemsSource = lvops.GetLvItems lvSource
		for li in itemsCATRig do li.selected = false
		for li in itemsSource do li.selected = false
		for node in selection do(
			for i=1 to itemsCATRig.count do
			(
				if itemsCATRig[i].Tag.value == node then(
					lvops.SelectLvItem lvCATRig (i-1)
					itemsCATRig[i].EnsureVisible();
				)
			)
			for i=1 to itemsSource.count do
			(
				if itemsSource[i].Tag.value == node then(
					lvops.SelectLvItem lvSource (i-1)
					itemsSource[i].EnsureVisible();
				)
			)
		)
	)
	
	fn FindCATNode catnode =
	(
		local lvCATRigItems      = lvops.GetLvItems lvCATRig;
		res = -1
		for i=1 to lvCATRigItems.count while (res == -1) do
		(
			if lvCATRigItems[i].tag.value == catnode then 
			(
				res = i;
			)
		)
		res
	)


	
	---------------------------------------------------------------------------
	
	-- These values are used to identify bones in
	-- the source rigs for the auto-mapping system. 
	local pelvis_names 	= #("LowerTorso", "Pelvis", "Root", "Hips", "VICON");
	local ribcage_names = #("thorax", "torso", "back", "Chest", "Spine", "Ribcage");
	local head_names 	= #("Head", "Neck");
	
--	local left_prefixs = #("L", "Left", "lf", "lt")--;
--	local right_prefixs = #("R", "Right", "rt");
	local left_prefixs 	= #("L"); 
	local right_prefixs	= #("R");
	
	local collarbone_names 	= #("Collar", "Clavical", "Shoulder");
	local upperarm_names 	= #("UpArm", "Shoulder", "UpperArm", "humerus", "Bicep");
--	local upperarm_names 	= #("Shoulder", "humerus", "Bicep", "Arm");
	local forearm_names 	= #("LowArm", "Elbow", "LowerArm", "wrist", "Forearm");
	local palm_names 		= #("Hand", "Wrist", "Palm");
	local finger_names 		= #("Hand");
--	local finger1_names 	= #("Knuckle");
	local thumb_names 		= #("Thumb");
	
	local thigh_names 		= #("Thigh", "Hip", "UpLeg", "femur", "UpperLeg");
	local calf_names 		= #("LowLeg", "Knee", "LowerLeg", "tibia", "Calf");
	local ankle_names 		= #("Foot", "Ankle");
	local toe_names 		= #("Toe", "Foot");
	
	
	fn MapNodes fromNode catNode alignment_tm =
	(
		-- Do we have a mapping layer that we can use to bind to the source animation?
		-- If not, create a new layer and use that.
		local hasMappingLayer = rCaptureAnim.targetLayerInfo != undefined and
				rCaptureAnim.catparent.layers.controller[rCaptureAnim.targetLayerInfo.layerindex] != undefined and
				rCaptureAnim.catparent.layers.controller[rCaptureAnim.targetLayerInfo.layerindex].controller == rCaptureAnim.targetLayerInfo
		
		if  not hasMappingLayer then
		(
			-- create the layer we should put the animation onto
			rCaptureAnim.catparent.AppendLayer (rCaptureAnim.targetLayerName+~MAPPING~) #Absolute
			rCaptureAnim.targetLayerInfo = rCaptureAnim.catparent.layers.controller[rCaptureAnim.catparent.selectedlayer].controller
			custAttributes.add rCaptureAnim.targetLayerInfo mappinglayerData #unique
			rCaptureAnim.catparent.catmode = 1;
		)
		
		local liindex = FindCATNode catNode;
		if liindex!= false then 
		(
		--	try (
				local layerindex = rCaptureAnim.targetLayerInfo.layerindex;
				local mappos = not catNode[3].AnimationLocks[1];
				local maprot = not catNode[3].AnimationLocks[2];
				
				case (classof catNode[3].controller) of
				(
					HubTrans:(			
						-- If we are mapping a head, then we should not map the position. 
						-- This is because ususally the heads poisiton is a lot less 
						-- important that its oreintation
						if catNode[3].inspine != undefined and catNode[3].limbs.count==0 then
							mappos = false;
					)
				)

				-- If there is no LayerTrans present, prevent this happening.
				local idxLayerTrans = findItem (getSubAnimNames catNode.controller) #LayerTrans
				if idxLayerTrans > 0 and catNode.controller[idxLayerTrans].controller != undefined then
				(
					
					catNode.controller.layertrans[layerindex].controller = CATTransformOffset()
					local transOffsetCtrl = catNode[3].layertrans[layerindex].controller;
					if mappos then (
						transOffsetCtrl.transform.controller.position.controller = Position_Constraint();
						transOffsetCtrl.transform.controller.position.controller.appendTarget fromNode  100.0
					)
					if maprot then (
						transOffsetCtrl.transform.controller.rotation.controller = Orientation_Constraint();
						transOffsetCtrl.transform.controller.rotation.controller.appendTarget fromNode  100.0
					)
					
					-- set the text and tag properties of the Listview's subitem
				--	setIndexedProperty li #subItems capture_col (fromNode.name)
					lvops.SetLvItemName lvCATRig (liindex-1) capture_col (fromNode.name);
					local lvCATRigItems = lvops.GetLvItems lvCATRig;
					
					if (classof alignment_tm)==Matrix3 then
						 transOffsetCtrl.offset.controller.value = alignment_tm;
					else if liindex>1 then
					(
						local rootlayerctrl = lvCATRigItems[1].tag.value[3].layertrans[layerindex].controller;
						if classof rootlayerctrl==CATTransformOffset then (
							alignment_tm = rootlayerctrl.offset.controller.value;
							alignment_tm.pos = [0,0,0]
							transOffsetCtrl.offset.controller.value = alignment_tm;
						)
					)
					
					case (classof catNode[3].controller) of
					(
					HubTrans:(			
						-- If we are mapping a tip hub, then we should make sure taht the inspine is a realtive one
						if catNode[3].inspine != undefined and mappos then
							catNode[3].inspine.layerabsrel.controller.selectedlayerctrl.value = 0.0f
					)
					)
				)
		--	)catch ()
		)
	)
	
	fn UnMapNode liindex = 
	(
		if liindex != false then 
		(
			try(
				local li = (lvops.GetLvItems lvCATRig)[liindex+1];
				local catnode = li.tag.value;
				local layerindex = rCaptureAnim.targetLayerInfo.layerindex;
				local tm = catnode.transform;
				catnode[3].layertrans[layerindex].controller = PRS();
				
				-- set the text and tag properties of the Listview's subitem
			--	setIndexedProperty li #subItems capture_col ""
				lvops.SetLvItemName lvCATRig liindex capture_col "";
				
				case (classof catNode[3].controller) of
				(
				HubTrans:(			
					-- If we are unmapping a tip hub, then put the spine back to normal
					if catNode[3].inspine != undefined then
						catNode[3].inspine.layerabsrel.controller[layerindex].controller.value = catNode[3].inspine.layerabsrel.controller.setupval
				)
				)
				if catnode[3].catparent.catmode==1 then
					catnode.transform = tm;
			
			)catch();

			return OK;
		)
	
	)
	
	fn ClearAllMapping = 
	(
		local panel = getCommandPanelTaskMode();
		setCommandPanelTaskMode mode:#display
		rCaptureAnim.SetStatus ~CLEARING_OLD_MAPPING~
		
		local lvItems = lvops.GetLvItems lvCATRig;
		for i=0 to lvItems.count do
		(
			UnMapNode i;
			rCaptureAnim.pbStatus.value = 100 *((i as float)/(lvItems.count as float));
		)
		-- put us back on the panel we were
		setCommandPanelTaskMode mode:panel
		rCaptureAnim.SetStatus ~DONE~
		rCaptureAnim.pbStatus.value = 0;
	)
	
	---------------------------------------------------------------
	-- given a list of names, look through the
	-- node array for any nodes whose names
	-- contain the strings in the names_array 
	fn FindNodes names_array node_array:undefined = 
	(
		-- if a node array wasn't passed in, then build one from the lvSource table
		if node_array==undefined then node_array = CollectSourceNodes();
		if node_array.count < 2 then return #();

		possible_nodes = #();
		-- build a list of all nodes that have names that contain the strings in the names_array
		for i=1 to node_array.count do
		(
			source_node = node_array[i]
			for possible_name in names_array do
			(
				if (findString source_node.name possible_name) != undefined then
				(
					append possible_nodes source_node;
				)
			)
		)
		return possible_nodes
	)

	---------------------------------------------------------------
	-- given a child and parent node, find out if the child is a decendant of the parent
	fn IsChildOf child_node parent_node = 
	(
		local n = child_node;
		while n.parent != undefined do 
		(
			if n.parent == parent_node then
				return true;
			n = n.parent;
		)
		return false;
	)
	
	---------------------------------------------------------------
	-- given an array, walk up the hierarchies, and if during the walk we find a
	-- node who is in our original list, we remove it from our original list 
	fn FindMostChildNodes &node_array =
	(
		local i=1;
		while (i <= node_array.count) do
		(
			local n = node_array[i];
			while n.parent != undefined do 
			(
				local parent_index = (FindItem node_array n.parent);
				if parent_index!=0 then
				(	
					deleteItem node_array parent_index;
					i = i - 1;
				)
				n = n.parent;
			)
			i = i + 1;
		)
	)
	
	---------------------------------------------------------------
	-- given an array, walk up the hierarchies, and if during the walk we find a
	-- node who is in our original list, we remove it from our original list 
	fn FindMostParentNodes &node_array =
	(
		local i=1;
		while (i <= node_array.count) do
		(
			local n = node_array[i];
			while n.parent != undefined do 
			(
				local parent_index = (FindItem node_array n.parent);
				if parent_index!=0 then
				(	
					deleteItem node_array i;
					i = i - 1;
				)
				n = n.parent;
			)
			i = i + 1;
		)
	)
	---------------------------------------------------------------
	-- Remove any bones that arn't a direct child of the parent node
	fn RemoveNonChildNodes &node_array parent_node = (
		local i = 1;
		while (i <= node_array.count) do(
			if node_array[i] == parent_node or (not IsChildOf node_array[i] parent_node) then(
				deleteItem node_array i;
				i = i - 1;
			)
			i = i + 1;
		)
	)
	---------------------------------------------------------------
	fn CollectSourceNodes parentnode:undefined = 
	(
		-- first gather objects from the left window
		local lvItems = lvops.GetLvItems lvSource
		
		local node_array = #();
		for i=1 to lvItems.count do
		(
			if lvItems[i].tag != undefined then
				append node_array lvItems[i].tag.value
		)
		if parentnode!= undefined then RemoveNonChildNodes &node_array l_parentnode
		return node_array;
	)
	---------------------------------------------------------------
	fn FindNode cat_bone names_array:undefined parentbone_in_hierarchy:undefined root_bias:false leaf_bias:false =
	(
		local possible_nodes;
		-- First we check for a perfect match. This would occur if the source hierarchy
		-- was an imported hierarchy that was orriginally a CATRig exported from max.
		possible_nodes = FindNodes #(cat_bone.name);
		if possible_nodes.count == 1 then	return possible_nodes[1];
		----------------------------------------------------------------
		if names_array==undefined then return undefined;
		----------------------------------------------------------------
		possible_nodes = FindNodes names_array;
		if possible_nodes.count==1 then		return possible_nodes[1];
		----------------------------------------------------------------
		-- weed out all terminator bones
		local terminator_nodes = FindNodes #("t_") node_array:possible_nodes;
		for tn in terminator_nodes do
		(
			local tn_index = FindItem possible_nodes tn 
			-- if we found a terminator node, remove it from the possible list of ribcage nodes
			if tn_index != 0 then deleteItem possible_nodes tn_index
		)
		if possible_nodes.count==1 then		return possible_nodes[1];
		----------------------------------------------------------------			
		if parentbone_in_hierarchy != undefined then(
			RemoveNonChildNodes &possible_nodes parentbone_in_hierarchy;
		)
		if possible_nodes.count==1 then		return possible_nodes[1];
		----------------------------------------------------------------
		-- we may have a hierarchy of bones. 	
		-- find the highest bone in the hierarchy.	
		if root_bias then FindMostParentNodes possible_nodes;
		-- Now we look down and find the most leaf bone
		if leaf_bias then FindMostChildNodes possible_nodes;
		----------------------------------------------------------------
		if possible_nodes.count >= 1 then return possible_nodes[1];
		else return undefined;
	)
	
	---------------------------------------------------------------		
	-- given a list of neams, look through the
	-- node array for any nodes whose names
	-- contain the strings in the names_array 
	fn FindLimbNodes names_array &l_bones_array &r_bones_array= 
	(
		-- if a node array wasn't passed in, then build one from the lvSource table
		local node_array = CollectSourceNodes();
	--	format " Source Node Array = % \n" node_array
	--	format "Finding bones = % \n" names_array
	--  print "--------------"

		l_bones_array = #();
		r_bones_array = #();
		-- build a list of all nodes that have names that contain the strings in the names_array
		for i=1 to node_array.count do
		(
			source_node = node_array[i]
			for possible_name in names_array do
			(
				local name_start_pos = (findString source_node.name possible_name);
				-- we have found a bone containing the name, 
				-- now we have to find out if it is left or right
				if name_start_pos != undefined then
				(
				--	format " Found Node = % \n" source_node
					-- we have to chop off the start of the name and scan that for left and right
					-- prefixes. The name itsself may contain the prefix as in 'l' in 'Palm'
					local bone_name_prefix = SubString source_node.name 1 (name_start_pos - 1);
				--	format "bone_name_prefix = % \n" bone_name_prefix;
					
					local isleft = findString bone_name_prefix "L";
					local isright = findString bone_name_prefix "R";
					if isleft != undefined and isright != undefined then
					(
						-- we can't be both, lets try and guess which one we really are.
						-- this situation may have occured because the bone name is prefixed with
						-- a string that may bave a name in it as in Model::LUpLeg -> Prefix is "Model::L"
						-- we do this by taking the last occurance of the 'L' or 'R' characters
						if isleft > isright then 	append l_bones_array source_node;
						else 						append r_bones_array source_node;
					)
					else(
						if isleft != undefined then			append l_bones_array source_node;
						if isright != undefined then		append r_bones_array source_node;
					)
				)
			)
		)
	)
	
	fn FindPelvis cat_pelvis = 
	(		
		local possible_nodes;
		
		if cat_pelvis != undefined then(
			-- First we check for a perfect match. This would occur if the source hierarchy
			-- was an imported FBX hierarchy that had been orriginally exported from max
			possible_nodes = FindNodes #(cat_pelvis.name);
			if possible_nodes.count == 1 then(
				return possible_nodes[1];
			)
		)		

	--	print "Finding Pelvis"
		local names = copy pelvis_names #noMap;
	--	append names cat_pelvis.name;
		
		possible_nodes = FindNodes names;
		if possible_nodes.count==1 then
			return possible_nodes[1];
			
		-----------------------------------------
		-- remove bones that have no children, are not animated,
		-- arn't the root of the hierarchy, or linked to something that is animated
		local i = 1;
		while (i < possible_nodes.count) do
		(
			local n = possible_nodes[i];
			-- we can't remove non Animated bones because we may be 
			-- mapping onto a skeleton with no animation. i.e . in base pose
		--	if (n.children.count == 0 or not n.pos.isAnimated) or (n.parent != undefined and not n.parent.pos.isAnimated) then
			if n.children.count == 0 then
			(
				deleteItem possible_nodes i;
				i = i - 1;
			)
			i = i + 1;
		)
		----------------------------------------------------------------
		-- we may have a list of all the vertebret in the spine. 
		-- Now we look down and find the end of the list
		FindMostParentNodes possible_nodes;
		
		----------------------------------------------------------------
		if possible_nodes.count >= 1 then
		(
			-- ask the user to pick a pelvis to use
			return possible_nodes[1];
		)
		else return undefined;
	)

	fn FindRibcage cat_ribcage = 
	(
		local possible_nodes;
		
		if cat_ribcage != undefined then(
			-- First we check for a perfect match. This would occur if the source hierarchy
			-- was an imported FBX hierarchy that had been orriginally exported from max
			possible_nodes = FindNodes #(cat_ribcage.name);
			if possible_nodes.count == 1 then(
				return possible_nodes[1];
			)
		)		
	--	print "Finding Ribcage"

		local names = copy ribcage_names #noMap;
	--	append names cat_ribcage.name;
		local possible_nodes = FindNodes names;
		if possible_nodes.count==1 then
			return possible_nodes[1];
		----------------------------------------------------------------
		-- weed out all terminator bones
		local terminator_nodes = FindNodes #("t_") node_array:possible_nodes;
		for tn in terminator_nodes do
		(
			local tn_index = FindItem possible_nodes tn 
			-- if we found a terminator node, remove it from the possible list of ribcage nodes
			if tn_index != 0 then deleteItem possible_nodes tn_index
		)
		----------------------------------------------------------------
		-- we may have a list of all the vertebret in the spine. 
		-- Now we look down and find the end of the list
		FindMostChildNodes possible_nodes;
		----------------------------------------------------------------
		if possible_nodes.count >= 1 then
		(
			-- ask the user to pick a bone to use
			return possible_nodes[1];
		)
		else return undefined;
	)
		
	fn FindHead cat_head = 
	(
		local names = copy head_names #noMap;
		append names cat_head.name;
		local possible_nodes = FindNodes names;
		if possible_nodes.count==1 then
			return possible_nodes[1];
		----------------------------------------------------------------
		-- if there are aim bones, then we remove the parent bones as we'd prefer to use the aim bones
		local aim_nodes = FindNodes #("aim") node_array:possible_nodes;		
		for an in aim_nodes  do
		(
			local an_index = FindItem possible_nodes an.parent
			if an_index != 0 then deleteItem possible_nodes an_index
		)		
		----------------------------------------------------------------
		-- weed out all terminator bones
		local terminator_nodes = FindNodes #("t_", "dummy", "end") node_array:possible_nodes;
		for tn in terminator_nodes  do
		(
			local tn_index = FindItem possible_nodes tn
			-- if we found a terminator node, remove it from the possible list of ribcage nodes
			if tn_index != 0 then deleteItem possible_nodes tn_index
		)
		----------------------------------------------------------------
		FindMostChildNodes possible_nodes;

		if possible_nodes.count > 0 then
		(
			-- TODO: maybe ask the user to pick a bone to use
			return possible_nodes[1];
		)
		else return undefined;
	)
		
	fn FindLimbBones &l_bone &r_bone names_array l_parentnode r_parentnode cat_l_bone:undefined cat_r_bone:undefined = 
	(
		local l_bone_nodes = #();
		local r_bone_nodes = #();		
		
		local names = copy names_array #noMap;
		if cat_l_bone!= undefined and cat_r_bone!= undefined then(
			-- First we check for a perfect match. This would occur if the source hierarchy
			-- was an imported hierarchy, that had been orriginally exported from max
			l_bone_nodes = FindNodes #(cat_l_bone.name);
			r_bone_nodes = FindNodes #(cat_r_bone.name);
			if l_bone_nodes.count > 0 and r_bone_nodes.count > 0 then(
				l_bone = l_bone_nodes[1];
				r_bone = r_bone_nodes[1];
				return OK;
			)
		)
		
		-- find all bones containing the names
		FindLimbNodes names &l_bone_nodes &r_bone_nodes;

		-----------------------------------------------------
		-- Remove any bones that arn't a direct child of the parent node
		if l_parentnode!= undefined then	RemoveNonChildNodes &l_bone_nodes l_parentnode

		----------------------------------------------------------------
		-- Remove any bones that arn't a direct child of the parent node
		if r_parentnode!= undefined then	RemoveNonChildNodes &r_bone_nodes r_parentnode
		
		----------------------------------------------------------------
		-- Pick a bone that we could use
		-- the bones were added to the list hierarchically so the 1st 
		-- one is also the highest in the hierarchy
		if l_bone_nodes.count >= 1 then		l_bone =  l_bone_nodes[1];
		else 								l_bone = undefined;
		----------------------------------------------------------------
		if r_bone_nodes.count >= 1 then		r_bone =  r_bone_nodes[1];
		else 								r_bone = undefined;
	)

	fn AutoMap = 
	(
		local catparent = rCaptureAnim.catparent;
		local lvItems = lvops.GetLvItems lvSource;
		if catparent == undefined or catparent.RootHub == undefined or lvItems.count < 3 then 
			return false;
		
		local panel = getCommandPanelTaskMode();
		setCommandPanelTaskMode mode:#display;
		
		if rCaptureAnim.targetLayerInfo!= undefined then(
			rCaptureAnim.SetStatus ~CLEARING_OLD_MAPPING_CAPTION~	
			rCATRigMapping.ClearAllMapping();	
		)else(
			-- create the layer we should put the animation onto
			catparent.AppendLayer (rCaptureAnim.targetLayerName+~MAPPING_CAPTION~) #Absolute
			rCaptureAnim.targetLayerInfo = catparent.layers.controller[catparent.selectedlayer].controller
			custAttributes.add rCaptureAnim.targetLayerInfo mappinglayerData #unique
			catparent.catmode = 1;
		)
		
		-- this auto map feature will look for the following bones in the source rig
		local pelvis, ribcage, head, l_upperarm, l_forearm, l_palm, l_digit, r_upperarm, r_forearm, r_palm, r_digit, l_thigh, l_calf, l_ankle, l_toe, r_thigh, r_calf, r_ankle, r_toe;
		local catpelvis, catribcage, cathead, catl_arm, catl_upperarm, catl_forearm, catl_palm, catl_finger, catr_arm, catr_upperarm, catr_forearm, catr_palm, catr_finger, catl_leg, catl_thigh, catl_calf, catl_ankle, catl_toe, catr_leg, catr_thigh, catr_calf, catr_ankle, catr_toe;
			
	--	try (
		undo off(
		
		catparent.catmode = 0;

		-- kick off the progress bar
		rCaptureAnim.setStatus ~AUTOMAPPING~
		rCaptureAnim.setProgress 0
		
		---------------------------------------------------------------
		-- get the CAT hubs
		catpelvis = catparent.roothub;
		if catparent.roothub.spines.count < 1 then return false;
		catribcage = catparent.roothub.spines[1].tiphub;
		
		if catparent.roothub.spines[1].tiphub.spines.count < 1 then return false;
		cathead = catparent.roothub.spines[1].tiphub.spines[1].tiphub;
		if pelvis == undefined and catpelvis.Limbs.count >= 2 then
		(
			catl_leg = catpelvis.Limbs[1];
			catr_leg = catpelvis.Limbs[2];
			catl_thigh = catl_leg.Bones[1].node;
			catr_thigh = catr_leg.Bones[1].node;
			catl_calf = catl_leg.Bones[2].node;
			catr_calf = catr_leg.Bones[2].node;
			catl_ankle = catl_leg.Palm.node.controller;
			catr_ankle = catr_leg.Palm.node.controller;
			if(catl_ankle.Digits.count > 0 and catl_ankle.Digits[1].Bones.count > 0)then
				catl_toe = catl_ankle.Digits[1].Bones[1].node
			if(catr_ankle.Digits.count > 0 and catr_ankle.Digits[1].Bones.count > 0)then
				catr_toe = catr_ankle.Digits[1].Bones[1].node
		)	
		---------------------------------------------------------------	
		-- find all the bones in the arms
		if catribcage != undefined and catribcage.Limbs.count >= 2 then
		(
			catl_arm = catribcage.Limbs[1];
			catr_arm = catribcage.Limbs[2];
			catl_collarbone = catl_arm.Collarbone
			catr_collarbone = catr_arm.Collarbone;
			catl_upperarm = catl_arm.Bones[1].node;
			catr_upperarm = catr_arm.Bones[1].node;
			catl_forearm = catl_arm.Bones[2].node;
			catr_forearm = catr_arm.Bones[2].node;
			catl_palm = catl_arm.Palm;
			catr_palm = catr_arm.Palm;
		)
		---------------------------------------------------------------
		-- find all the bones in the source hierarchy
		pelvis = FindPelvis catpelvis.node;
		ribcage = FindRibcage catribcage.node; 
		head = FindHead cathead.node;
		
		rCaptureAnim.setProgress 5
		
		-- we shouldn't keep trying to map if we havn't got these guys 
		if pelvis == undefined or ribcage == undefined or head == undefined then return false;	

		
		-- find the bone th direct child of the ribcage that is the parent of the head
		-- we want to calculate the lenght of the ribcage bone and make that our offset
		local n = head;
		while n.parent != undefined and  n.parent!= ribcage do n = n.parent;
		local ribcage_pos_offset = n.transform.translation * Inverse(ribcage.transform);
		
		rCaptureAnim.setProgress 10
		
		---------------------------------------------------------------
		-- find all the bones in the legs
		FindLimbBones &l_thigh 	&r_thigh 	thigh_names 	pelvis 		pelvis 	cat_l_bone:catl_thigh 		cat_r_bone:catr_thigh;
		rCaptureAnim.setProgress 20
		FindLimbBones &l_calf 	&r_calf		calf_names 		l_thigh 	r_thigh cat_l_bone:catl_calf 		cat_r_bone:catr_calf ;
		rCaptureAnim.setProgress 25
		FindLimbBones &l_ankle 	&r_ankle 	ankle_names 	l_calf 		r_calf 	cat_l_bone:catl_ankle.node 	cat_r_bone:catr_ankle.node;
		rCaptureAnim.setProgress 30
		FindLimbBones &l_toe 	&r_toe 		toe_names 		l_ankle 	r_ankle cat_l_bone:catl_toe 	 	cat_r_bone:catr_toe;
		rCaptureAnim.setProgress 35

		---------------------------------------------------------------
		rCaptureAnim.setProgress 15
		
		FindLimbBones 	&l_collarbone 	&r_collarbone 	collarbone_names 	ribcage 		ribcage 			cat_l_bone:catl_collarbone.node 	cat_r_bone:catr_collarbone.node;
		rCaptureAnim.setProgress 40
		if l_collarbone != undefined and r_collarbone != undefined then
			 FindLimbBones &l_upperarm 	&r_upperarm 	upperarm_names 		l_collarbone 	r_collarbone 		cat_l_bone:catl_upperarm			cat_r_bone:catr_upperarm;
		else FindLimbBones &l_upperarm 	&r_upperarm 	upperarm_names 		ribcage 		ribcage 			cat_l_bone:catl_upperarm			cat_r_bone:catr_upperarm;
		rCaptureAnim.setProgress 45
		FindLimbBones 	&l_forearm 		&r_forearm 		forearm_names 		l_upperarm 		r_upperarm 			cat_l_bone:catl_forearm 			cat_r_bone:catr_forearm;
		rCaptureAnim.setProgress 50
		FindLimbBones 	&l_palm 		&r_palm 		palm_names 			l_forearm 		r_forearm 			cat_l_bone:catl_palm.node 		cat_r_bone:catr_palm.node;
		rCaptureAnim.setProgress 55
		FindLimbBones 	&l_finger 		&r_finger 		toe_names 			l_palm 			r_palm;
		rCaptureAnim.setProgress 60
		
		gc();
		
		---------------------------------------------------------------
		-- make a matrix to transform from the src hierarchy to CAT
	--	print ((pelvis as string) + (ribcage as string) + (r_thigh as string) + (l_thigh as string))
		local tm_source2cat = Matrix3 1;
		if pelvis != undefined and ribcage != undefined and r_thigh != undefined and l_thigh  != undefined then
		--	pelvis.name != catpelvis.node.name and ribcage.name != catribcage.node.name	then
		(
			local tm_ribcage = ribcage.transform;
			preTranslate  tm_ribcage ribcage_pos_offset;
			
			local tm_cat = Matrix3 1;
			local tm_src = tm_ribcage;

			tm_src = pelvis.transform;
			if catparent.LengthAxis=="Z" then
			(
				tm_cat.row1 = Normalize(r_thigh.transform.pos - l_thigh.transform.pos);
				tm_cat.row3 = Normalize(tm_ribcage.pos -  pelvis.transform.pos);
				tm_cat.row2 = Normalize(cross tm_cat.row3 tm_cat.row1);
				tm_cat.row3 = Normalize(cross tm_cat.row1 tm_cat.row2);
			)else(
				tm_cat.row3 = Normalize(l_thigh.transform.pos - r_thigh.transform.pos);
				tm_cat.row1 = Normalize(tm_ribcage.pos -  pelvis.transform.pos);
				tm_cat.row2 = Normalize(cross tm_cat.row3 tm_cat.row1);
				tm_cat.row1 = Normalize(cross tm_cat.row2 tm_cat.row3);
			--	tm_cat = matrix3 1
			)

			tm_source2cat = tm_cat * (Inverse tm_src);
			tm_source2cat.translation = [0.0, 0.0, 0.0];
			
			---------------------------------------------------------------
			-- We need a simple square offset matrix that rotaest 
			-- bones by 90 degree chunks, make sense? so far the matrix would apply an arbitrary modification
			FindOrthonormalMatrix &tm_source2cat;

		)
		
		rCaptureAnim.setProgress 65
		

		---------------------------------------------------------------
		local tm_pelvis_offset = copy tm_source2cat;
		if r_thigh != undefined and l_thigh != undefined and pelvis.name != catpelvis.node.name then(
			-- generate an offset for the pelvis based on the positions of the hips
			tm_pelvis_offset.translation = ((pelvis.transform.translation + l_thigh.transform.translation + r_thigh.transform.translation)/3.0) * Inverse(pelvis.transform)
		)
		MapNodes pelvis catpelvis.node tm_pelvis_offset;
		
		---------------------------------------------------------------
		local tm_ribcage_offset = copy tm_source2cat;
		tm_ribcage_offset.translation = ribcage_pos_offset;
		MapNodes ribcage catribcage.node tm_ribcage_offset;
		
		rCaptureAnim.setProgress 70
		
		---------------------------------------------------------------
		-- often we have aim bones that are pointing forwards
		-- here we try to detect this case, and apply and offset that will 
		-- straighten up the head
		local tm_head_offset = copy tm_source2cat;
		if head.name != cathead.node.name then(
			if head.parent != ribcage then
			(
				local headlocal = head.transform * Inverse(head.parent.transform);
				if head.children.count > 0 then (
					local headangle = acos (dot (Normalize(head.children[1].transform.pos - head.transform.pos)) (Normalize(head.transform.pos - head.parent.transform.pos)))
					-- we figure out how much the head bone is an 'aim' bone, and then
					local headangle = (headangle/90.0);
					if headangle > 1.0 then headangle = 1.0;
					headlocal = (slerp (quat 0 0 0 1) (Quat headlocal) headangle) as Matrix3
				)
				tm_head_offset = tm_source2cat * Inverse(headlocal);
				tm_head_offset.translation = [0.0, 0.0, 0.0]
			)
			if head.children.count > 0 then 
				tm_head_offset.translation = (head.children[1].transform * Inverse(head.transform)).translation;
		)

		MapNodes head cathead.node tm_head_offset;
		
		rCaptureAnim.setProgress 75
		
		gc();
	
		---------------------------------------------------------------
		-- Map the leg bones form the src bones to the CAT bones
		if l_thigh!= undefined and catl_thigh!= undefined then		MapNodes l_thigh catl_thigh tm_source2cat;
		if r_thigh!= undefined and catr_thigh!= undefined then		MapNodes r_thigh catr_thigh tm_source2cat;
		if l_calf != undefined and catl_calf != undefined then		MapNodes l_calf catl_calf tm_source2cat;
		if r_calf != undefined and catr_calf != undefined then		MapNodes r_calf catr_calf tm_source2cat;
		
		rCaptureAnim.setProgress 80

		------------------------------------------------------------------------------------------------------
		-- Do the Ankles
		local tm_ankle_offset = copy tm_source2cat;
		if catparent.LengthAxis=="Z" and (classof l_ankle)== Biped_Object then
			preRotateX tm_ankle_offset -90.0;
		else if l_calf != undefined and l_ankle != undefined and l_ankle.children.count > 0 then
		(		
			if catparent.LengthAxis=="Z" then (
				tm_ankle_offset.row3 = Normalize(l_ankle.children[1].transform.pos -  l_ankle.transform.pos);
				tm_ankle_offset.row2 = Normalize(l_calf.transform.pos -  l_ankle.transform.pos);
				tm_ankle_offset.row1 = Normalize(cross tm_ankle_offset.row2 tm_ankle_offset.row3);
				tm_ankle_offset.row3 = Normalize(cross tm_ankle_offset.row1 tm_ankle_offset.row2);
			)else(
				tm_ankle_offset.row1 = Normalize(l_ankle.children[1].transform.pos - l_ankle.transform.pos);
				tm_ankle_offset.row2 = Normalize(l_calf.transform.pos - l_ankle.transform.pos);
				tm_ankle_offset.row3 = Normalize(cross tm_ankle_offset.row1 tm_ankle_offset.row2);
				tm_ankle_offset.row1 = Normalize(cross tm_ankle_offset.row2 tm_ankle_offset.row3);
			)
			
			tm_ankle_offset = tm_ankle_offset * (Inverse l_ankle.transform);
			tm_ankle_offset.translation = [0.0, 0.0, 0.0];
			
			---------------------------------------------------------------
			-- We need a simple square offset matrix that rotaest 
			-- bones by 90 degree chunks, make sense? so far the matrix would apply an arbitrary modification
			FindOrthonormalMatrix &tm_ankle_offset;
		)
		
		if l_ankle != undefined and catl_ankle != undefined then		MapNodes l_ankle catl_ankle.node tm_ankle_offset;
		if r_ankle != undefined and catr_ankle != undefined then		MapNodes r_ankle catr_ankle.node tm_ankle_offset;
		
		if(catl_leg.IKTarget != undefined) then
		(
			local tm_iktarg_offset = copy tm_ankle_offset;
			if catparent.LengthAxis=="Z" then (
				preRotateX tm_iktarg_offset 90.0;
				preRotateY tm_iktarg_offset 180.0;
			)else(
				preRotateZ tm_iktarg_offset -90.0;
				preRotateY tm_iktarg_offset 180.0;
			)
			if l_toe != undefined and (classof l_ankle)!= Biped_Object then
			(
				if catl_ankle != undefined and catl_ankle.numdigits==1 then(
					tm_iktarg_offset = copy tm_ankle_offset;
					tm_iktarg_offset = (catl_leg.IKTarget.transform * (inverse catl_ankle.Digits[1].Bones[1].node.transform)) * tm_iktarg_offset;
				)
				MapNodes l_toe catl_leg.IKTarget tm_iktarg_offset;
			)
			else
			(
				preTranslate tm_iktarg_offset [0.0, (catl_ankle.Node.baseobject.Length *  catl_ankle.Node.baseobject.CATUnits * 0.5), 0.0]
				-- Assuming both the source and target feet are flat on the ground.
				
				if l_ankle != undefined then 	MapNodes l_ankle catl_leg.IKTarget tm_iktarg_offset;
			)
		)
		if catl_ankle.numdigits > 0 and catl_ankle.Digits[1].NumSegs > 0 and l_toe != undefined then
		(
			catl_toe = catl_ankle.Digits[1].Bones[1];
			if l_toe != undefined and catl_toe != undefined then		MapNodes l_toe catl_toe.node tm_source2cat;
		)
		
		rCaptureAnim.setProgress 85
		
		if(catr_leg.IKTarget != undefined) then
		(
			local tm_iktarg_offset = copy tm_ankle_offset;
			if catparent.LengthAxis=="Z" then (
				preRotateX tm_iktarg_offset 90.0;
				preRotateY tm_iktarg_offset 180.0;
			)else(
				preRotateZ tm_iktarg_offset -90.0;
				preRotateY tm_iktarg_offset 180.0;
			)
			
			if r_toe != undefined and (classof r_ankle)!= Biped_Object then
			(
				if catr_ankle != undefined and catr_ankle.numdigits==1 then(
					tm_iktarg_offset = copy tm_ankle_offset;
					tm_iktarg_offset = (catr_leg.IKTarget.transform * (inverse catr_ankle.Digits[1].Bones[1].node.transform)) * tm_iktarg_offset;
				)
				MapNodes r_toe catr_leg.IKTarget tm_iktarg_offset;
			)
			else
			(
				preTranslate tm_iktarg_offset [0.0, (catr_ankle.Node.baseobject.Length *  catr_ankle.Node.baseobject.CATUnits * 0.5), 0.0]
				if r_ankle != undefined then 	MapNodes r_ankle catr_leg.IKTarget tm_iktarg_offset;
			)
		)
	--	else 
		if catr_ankle.numdigits > 0 and catr_ankle.Digits[1].NumSegs > 0 and r_toe != undefined then
		(
			catr_toe = catr_ankle.Digits[1].Bones[1];
			if r_toe != undefined and catr_toe != undefined then		MapNodes r_toe catr_toe.node tm_source2cat;
		)
		
		rCaptureAnim.setProgress 90
		
		gc();
			
		---------------------------------------------------------------
		-- Map the arm bones form the src bones to the CAT bones
		if catribcage.Limbs.count >= 2 then
		(
			local tm_arm_offset = copy tm_source2cat;
			if (classof l_upperarm)==Biped_Object then
			(
				if catparent.LengthAxis=="Z" then
					 preRotateZ tm_arm_offset 180.0;
				else preRotateX tm_arm_offset 180.0;
			)
			-- Only map the collarbones if the namesmatch exactly. This is because often collarbones have wierd
			-- offsets.. TODO we need to calculate the offset matrix for the collarbone assuming this is a relaxed pose
		--	print (catl_collarbone.name + " == " + l_collarbone.name);
		--	print (catr_collarbone.name + " == " + r_collarbone.name);
			if catl_collarbone != undefined and l_collarbone != undefined and catl_collarbone.node.name==l_collarbone.name then	
				MapNodes l_collarbone catl_collarbone.node tm_arm_offset;
			if catr_collarbone != undefined and r_collarbone != undefined and catr_collarbone.node.name==r_collarbone.name then	
				MapNodes r_collarbone catr_collarbone.node tm_arm_offset;
			
			if l_upperarm != undefined and catl_upperarm != undefined then		MapNodes l_upperarm catl_upperarm tm_arm_offset;
			if r_upperarm != undefined and catr_upperarm != undefined then		MapNodes r_upperarm catr_upperarm tm_arm_offset;
			if l_forearm != undefined and catl_forearm != undefined then		MapNodes l_forearm catl_forearm tm_arm_offset;
			if r_forearm != undefined and catr_forearm != undefined then		MapNodes r_forearm catr_forearm tm_arm_offset;
						
			rCaptureAnim.setProgress 95
			
			local tm_lpalm_offset = copy tm_arm_offset;
			if catl_palm != undefined and l_palm != undefined then
			(
				if l_palm.name != catl_palm.node.name then 	-- Reimported, Exported CATRigs 
				(
					if catparent.LengthAxis=="Z" then 
						 preRotateZ tm_lpalm_offset (90.0 * catl_arm.lmr);
					else preRotateX tm_lpalm_offset (90.0 * catl_arm.lmr);
				)
				
			--	if catparent.LengthAxis=="Z" and (classof l_palm)==Biped_Object then
			--		preRotateZ tm_palm_offset (-90.0 * catl_arm.lmr);
					
				if (classof l_palm)==Biped_Object then				-- BIP
				(
					if catparent.LengthAxis=="X" then 
						 tm_lpalm_offset = rotateXMatrix 180
					else preRotateZ tm_lpalm_offset (-90.0 * catl_arm.lmr);
				)-- else if l_palm.name == catl_palm.node.name then 	-- FBX
				--	tm_lpalm_offset = Matrix3 1
				
				MapNodes l_palm catl_palm.node tm_lpalm_offset;	

				if catl_palm.node.name == l_palm.name then (
					-- Look for all the digits in the scene. 
					-- They probably exist if this is a perfect mapping.
					local parbone = l_palm;
					for digit in catl_palm.digits do
					(
						for bone in digit.bones do
						(
							local maxbone = FindNode bone.node parentbone_in_hierarchy:parbone;
							if maxbone!=undefined then(
								MapNodes maxbone bone.node tm_lpalm_offset;	
								parbone = maxbone;
							)
						)
					)
				)	
			)
			-- Map the L IKTarget
			if catl_arm.IKTarget != undefined and l_palm != undefined then(
				local tm_iktarget_offset = copy tm_lpalm_offset;
				if catparent.LengthAxis=="Z" then
					 preRotateX tm_iktarget_offset 180.0;
				else preRotateZ tm_iktarget_offset 180.0;
				if catparent.LengthAxis=="Z" then
					 preRotateZ tm_iktarget_offset 180.0;
				else preRotateX tm_iktarget_offset 180.0;
				
				if l_palm.children.count==1 then (
					local palmlength = Length(l_palm.children[1].transform.pos - l_palm.transform.pos);
					if catparent.LengthAxis=="Z" then
						 preTranslate tm_iktarget_offset [0,0,-palmlength];
					else preTranslate tm_iktarget_offset [-palmlength,0,0];
				)
				
				MapNodes l_palm catl_arm.IKTarget tm_iktarget_offset;
			)
			
			rCaptureAnim.setProgress 100
			
			local tm_rpalm_offset = copy tm_arm_offset;
			if catr_palm != undefined and r_palm != undefined then
			(
				if l_palm.name != catl_palm.node.name then 	-- Reimported, Exported CATRigs 
				(
					if catparent.LengthAxis=="Z" then 
						 preRotateZ tm_rpalm_offset (90.0 * catr_arm.lmr);
					else preRotateX tm_rpalm_offset (-90.0 * catl_arm.lmr);
				)
				
				if (classof r_palm)==Biped_Object then
				(
					if catparent.LengthAxis=="X" then 
						 tm_rpalm_offset = rotateXMatrix 180
					else preRotateZ tm_rpalm_offset (-90.0 * catr_arm.lmr);
				)-- else if r_palm.name == catr_palm.node.name then 	-- FBX
				--	tm_rpalm_offset = Matrix3 1
				
				MapNodes r_palm catr_palm.node tm_rpalm_offset;
				
				if catr_palm.node.name == r_palm.name then (
					-- Look for all the digits in the scene. 
					-- They probably exist if this is a perfect mapping.
					local parbone = r_palm;
					for digit in catr_palm.digits do
					(
						for bone in digit.bones do
						(
							local maxbone = FindNode bone.node parentbone_in_hierarchy:parbone;
							if maxbone!=undefined then(
								MapNodes maxbone bone.node tm_lpalm_offset;	
								parbone = maxbone;
							)
						)
					)
				)
			)
			-- Map the R IKTarget
			if catr_arm.IKTarget != undefined and r_palm != undefined then (
				local tm_iktarget_offset = copy tm_rpalm_offset;
				if catparent.LengthAxis=="Z" then
					 preRotateX tm_iktarget_offset 180.0;
				else preRotateZ tm_iktarget_offset 180.0;
				if catparent.LengthAxis=="Z" then
					 preRotateZ tm_iktarget_offset 180.0;
				else preRotateX tm_iktarget_offset 180.0;
				
				if r_palm.children.count==1 then (
					local palmlength = Length(r_palm.children[1].transform.pos - r_palm.transform.pos);
					if catparent.LengthAxis=="Z" then
						 preTranslate tm_iktarget_offset [0,0,-palmlength];
					else preTranslate tm_iktarget_offset [-palmlength,0,0];
				)
				
				MapNodes r_palm catr_arm.IKTarget tm_iktarget_offset;
			)
		)
		
		rCaptureAnim.setProgress 100;
		catparent.catmode = 1;
		
		-- put us back on the panel we were
		setCommandPanelTaskMode mode:panel
				
		rCaptureAnim.Refresh();
		OK;
		)
	--	)catch(
	--		rCaptureAnim.SetStatus "AutoMap Failed"
	--		rCaptureAnim.pbStatus.value = 0;
	--		false;
	--	)

	)
	
	on lvCATRig DoubleClick arg do
	(
		local lvn = lvops.GetLvSingleSelected lvCATRig
		print lvn;
		if lvn != undefined then
		(			
			local catNode = lvn.tag.value;
			if catNode != undefined then
			(
				clearSelection();
				select catNode;
			)
		)
	)

	on lvSource DoubleClick arg do
	(
	--	lvn = lvSource.selectedItem
		local lvn = lvops.GetLvSingleSelected lvSource;
		if lvn != undefined then
		(
			local sourceNode = lvn.tag.value;
			if sourceNode != undefined then
			(
				clearSelection();
				select sourceNode;
			)
		)
	)

	-------------------------------------------------------------------------------------------
	-- All the drag & drop stuff
	-------------------------------------------------------------------------------------------

	on lvSource ItemDrag arg do
	(
		-- arg is System.Windows.Forms.ItemDragEventArgs
		drag_node = arg.item
		local effect = dotNetclass "System.Windows.Forms.DragDropEffects"	
		lvSource.DoDragDrop arg.item effect.move
	)

	on lvCATRig DragEnter arg do
	(
		-- arg is System.Windows.Forms.DragEventArgs
		if (arg.data.GetDataPresent(dotNetClass "System.Windows.Forms.ListViewItem")) do
		(
			local dragDropEffect = dotNetclass "System.Windows.Forms.DragDropEffects"
			arg.effect = dragDropEffect.move
			in_drop = true
			lvCATRig.multiselect = false
		)
	)
	on lvCATRig DragLeave arg do
	(
		-- arg is System.EventArgs
		if (in_drop) do
		(
			in_drop = false
			lvCATRig.multiselect = true
		)	
	)
	on lvCATRig DragOver arg do
	(
		--This highlights the ListViewItem that is directly under the mouse
   		--arg is System.Windows.Forms.DragEventArgs
   		if (arg.data.GetDataPresent(dotNetClass "System.Windows.Forms.ListViewItem")) then
		(
			local position = dotNetObject "System.Drawing.Point" arg.x arg.y
			position         = lvCATRig.pointToClient position
			local hitTestInfo = lvCATRig.HitTest position
			local dropLVItem = hitTestInfo.Item

			if dropLVItem != undefined then
			(
				-- Do NOT highlight items that do not have a layerTrans controller.
				local catnode = dropLVItem.tag.value;
				
				local idxLayerTrans = findItem (getSubAnimNames catnode.controller) #LayerTrans
				if (idxLayerTrans > 0 and catnode.controller[idxLayerTrans].controller != undefined) do
					dropLVItem.selected = true
			)
		)
	)
	

	on lvCATRig DragDrop arg do 
	( 			
		-- arg is System.Windows.Forms.DragEventArgs
		if (arg.data.GetDataPresent(dotNetClass "System.Windows.Forms.ListViewItem")) do
		(
			-- What are we dropping on?
			local selDropIndices = lvCATRig.selectedIndices;
			-- We only support 1 drop target
			if selDropIndices.count != 1 then
				return false;
			
			-- Guess what has the only 0-based index in all of Max...
			local selDropItems = selDropIndices.item
			local dropIndex = selDropItems[0] ;
			
			local selectedSourceItems = lvops.GetLvSelection lvSource
			local selectedCount       = selectedSourceItems.count
			local lvCATRigItems      = lvops.GetLvItems lvCATRig
			
			local i = 1
			--for each selected dragged node
			local notDone = true
			for dragged in selectedSourceItems while notDone do
			(
				--get a scene node to assign with.
				lvItem = lvCATRigItems[dropIndex + i]
				--and if the end of the list hasn't been reached
				if (lvItem != undefined) then 
				(
					--then get the subitem in the second column.
					lvSubItem = lvItem.subItems.item[1]
					
					--now copy the actual data
					MapNodes dragged.tag.value lvItem.tag.value undefined
					
					--increment the counter
					i += 1
				)
				else
				(
					--most likely reached the end of the list. 
					notDone = false
				)
			)
			lvCATRig.multiselect = true
			gc()
		)
		rCaptureAnim.Refresh();
	)	

	on lvCATRig keyUp arg do
	( 
		local key = arg.keyValue
		if ( key==32 or key==8 or key==100) do -- ASCII value for SPACEBAR, BACKSPACE and DELETE
		(
			local lvItems = lvops.GetLvItems lvCATRig;
			for li in lvItems do(
				if li.selected then UnMapNode li.index
			)
		)
	)
)
  
  
rollout rCaptureAnim ~CAPTURE_ANIMATION~ width:620 height:175
(
	local targetLayerInfo;
	local targetLayerName = ~TARGETLAYERNAME_MAPPING~
	local quiet = false;
--	local starttime, endtime, frequency = 2;
	local version = 0;
	local catrigFilt;
	local capture_col = 1,	ini_file = ((getDir #plugcfg_ln) + "\\CAT\\captureAnim.ini");
	local lvSource, lvCATRig;
	
	-- various colors
	local anim_color = 255, proc_color = 16744192, err_color = 1777088
	
	-- Temporary vertical UI offset
	local row2height = 80
	
	-- Capture variables
	local catparent, source_root, source_nodes, map_stream;
			
	-- counters
	local indentVal = 1

	---------------------------------------------------------------------------------------
	-- filter out any CATObjects already assigned as our destination.
	fn srcObjFilter obj = (
		-- If we have no destination yet, allow setting src
		res = true
		if rCaptureAnim.catparent != undefined do (
			-- we have destination
			if (getInterface obj.controller "CATNodecontrolFPInterface") != undefined then (
				res = obj.controller.CATParent != rCaptureAnim.catparent
			)
			else res = true;
		)
		res
	)

	local srcobjpos = [5, 2]
	groupBox grpSource ~GRPSOURCE~ 	pos:srcobjpos width:225 height:115
	pickbutton	 btnSourceObj	~BTNSOURCEOBJ_BUTTONTEXT~ 		pos:[srcobjpos.x+20,	srcobjpos.y+028] width:100 height:20	filter:srcObjFilter
	checkbox chkDeleteSource ~DELETE_SOURCE_ON_CLOSE~ 	pos:[srcobjpos.x+20,	srcobjpos.y+082] width:~CHKDELETESOURCE_WIDTH~ height:17 tooltip:~DELETE_ALL_SOURCE_NODES_WHEN_WINDOW_CLOSED~

	pickbutton	 btnTargetRig	~TARGET_RIG~ 	pos:[srcobjpos.x+20,	srcobjpos.y+54]
												message:~PICK_RIG_CAPTURE_ANIMATION_ONTO~
												filter:catrigFilt
												 width:100 height:20

	---------------------------------------------------------------------------------------
	local mappingpos = [235, 35]
	groupBox grpMapping ~GRPMAPPING_CAPTION~ pos:mappingpos width:225 height:row2height
	
	
	button	 btnAutoMap			~AUTO_MAP~ 		pos:[mappingpos.x+10, mappingpos.y + 20] width:100 height:20
	button	 btnClearMapping	~CLEAR_MAPPING~ pos:[mappingpos.x+10, mappingpos.y + 45] width:100 height:20
	
	button	 btnLoadMapping		~LOAD~ 	pos:[mappingpos.x+115, mappingpos.y + 20] width:100 height:20
	button	 btnSaveMapping		~SAVE~ 	pos:[mappingpos.x+115, mappingpos.y + 45] width:100 height:20
	
	---------------------------------------------------------------------------------------	
	local cappos = [465, 35]
	groupBox grpCapture ~CAPTURE~ pos:cappos width:150 height:row2height
	button	 btnCapture	~CAPTURE_ANIMATION_BUTTONTEXT~	pos:[cappos.x+10,cappos.y+020] width:130 height:45 enabled:false
		
	---------------------------------------------------------------------------------------	
	local capdetailspos = [235, 2]
	groupBox grpCapDetails "" pos:capdetailspos width:380 height:33
	spinner	spnStartTime	~START_TIME~ 	pos:[capdetailspos.x+15, capdetailspos.y+12] 	type:#integer fieldwidth:35 range:[-100000,100000,animationRange.start] enabled:true
	spinner	spnEndTime		~END_TIME~ 	pos:[capdetailspos.x+142,capdetailspos.y+12] 	type:#integer fieldwidth:35 range:[-100000,100000,animationRange.end] enabled:true
	spinner spnFreq 		~FREQUENCY~ 	pos:[capdetailspos.x+265,capdetailspos.y+12] 	type:#integer fieldwidth:35 range:[1,100,1]

	---------------------------------------------------------------------------------------
	local rolloutY = 120;
	subRollout srRollouts	""				pos:[005,rolloutY] 				width:610 			height:25
	
	label 			lblStatus 	~STATUS~		width:125 height:20					pos:[5, rolloutY+30] 
	progressBar  	pbStatus	 ""				width:480 height:20 color:red		pos:[130, rolloutY+30] 
	
	---------------------------------------------------------------------------------------
	-- Functions
	---------------------------------------------------------------------------------------

	fn catrigFilt o = (
		cpt = GetCATParent o
		res = cpt != undefined
		if (cpt != undefined) do (
			if ((source_nodes != undefined) and (source_nodes.count > 0)) do (
				res = GetCATParent source_nodes[1] != cpt
			)
		)
		res
	)
	
	fn EnableUI onoff =
	(
		btnCapture.Enabled = onoff
	)
	fn highlight tvNode subAnim =
	(
		if xmlio.isAnimated subAnim do ( tvNode.forecolor = anim_color; tvNode.bold = true )
	)
	
	-------------------------------------------------------------------------------------------
	-- Statusbar functions
	-------------------------------------------------------------------------------------------
	fn setStatus text error:false =
	(
		lblStatus.text = text
	)
	fn setProgress per =
	(
		pbStatus.value = per
	)
	-------------------------------------------------------------------------------------------
	-- Listview functions
	-------------------------------------------------------------------------------------------	

	fn addNodesToListView lv source_nodes pattern_string:undefined recurse:true indent:0 =
	(
	--	local lv_nodes = lv.listItems
		local lv_nodes = lvops.GetLvItems lv
		for i=1 to source_nodes.count do
		(
			local c = source_nodes[i], add_node = TRUE, lvn
			if c==undefined then continue;
				
		--	lvn = lv_nodes.add()
			local lvn = lvops.AddLvItem lv pTextItems:#(c.name,"") pTag:(dotNetMXSValue c) pIndent:indent
		--	lvn.text = c.name
		--	listView.setIndent lv.hwnd lvn.index indent
		--	lvn.tag.value = c -- save a pointer to the node in the tag property
			
			addNodesToListView lv c.children pattern_string:pattern_string indent:(indent + indentVal);
		)
	)
	
	fn GetSrcNode catNode = 
	(
		try(
			if targetLayerInfo==undefined then return undefined;
			local layerctrl = catNode[3].layertrans[targetLayerInfo.layerindex].controller;
			if classof layerctrl==CATTransformOffset then
			(
				if classof layerctrl.transform.controller.rotation.controller == Orientation_Constraint then
					return layerctrl.transform.controller.rotation.controller.getNode 1
				else if classof layerctrl.transform.controller.position.controller == Position_Constraint then
					return layerctrl.transform.controller.rotation.controller.getNode 1
			)
		)catch( )
		return undefined;
	)
	

	fn add_catrig_node catNode catctrl indent =
	(
	--	lvn = lvCATRig.listItems.add()
		local lvn = lvops.AddLvItem lvCATRig pTextItems:#(catNode.name,"") pTag:(dotNetMXSValue c) pIndent:indent
		
	--	try(
			if targetLayerInfo!= undefined then
			(
				local fromNode = GetSrcNode catNode;
				if fromNode != undefined then(
					lvops.SetLvItemName lvCATRig lvn.index capture_col (fromNode.name);
				)
				--	setIndexedProperty lvn #subItems capture_col (fromNode.name);
			)
	--	)catch()
		
	--	lvn.text = catNode.name;
	--	listView.setIndent lvCATRig.hwnd lvn.index indent
		lvn.tag = dotnetMXSValue catNode
		
		for i=1 to catNode[3].controller.NumArbBones do
			add_catrig_node (catNode[3].GetArbBone i).node catctrl (indent+1)	
	)
	fn recurseCATRig hub indent =
	(
	--	local lv_nodes = lv.listItems
		
		add_catrig_node hub.Node hub indent
		
		hub.PinHub = false;
		
		-- add all the limbs
		for i = 1 to hub.Limbs.count do
		(
			local limbindent = (indent + indentVal);
			limb = hub.Limbs[i];	
	
			collarbone = limb.collarbone
			if(collarbone != undefined)then
			(
				add_catrig_node collarbone.Node collarbone limbindent
				limbindent = limbindent + 1;
			)			
			
			-- we really should add the IK targets first
			-- this is because the 
			if(limb.IKTarget != undefined)then
			(
				add_catrig_node limb.IKTarget limb.IKTarget[3].controller (limbindent + 1)
			)
			if(limb.upnode != undefined)then
			(
				add_catrig_node limb.upnode limb.upnode[3].controller (limbindent + 1)
			)
	
			for j = 1 to limb.Bones.count do
			(
				local bone = limb.Bones[j]
				add_catrig_node bone.node bone limbindent
				limbindent = limbindent + 1;
			)
			
			palm = limb.Palm;
			if(palm != undefined)then
			(
				local palmindent = (limbindent + indentVal);
				add_catrig_node palm.Node palm palmindent
				-- We need to cast out to the full controller to access
				-- the palm-specific interface for accessing digits.
				digits = palm.node.controller.digits
				for j = 1 to digits.count do
				(
					digit = digits[j];
					for k = 1 to digit.Bones.count do
					(
						seg = digit.Bones[k];
						add_catrig_node seg.Node seg (palmindent + k)
					)
				)
			)
		)
		for i = 1 to hub.tails.count do
		(
			tail = hub.tails[i];
		)
		for i = 1 to hub.spines.count do
		(
			local spineindent = (indent + indentVal);
			spine = hub.spines[i];
			for j = 1 to spine.Bones.count do
			(
				local bone = spine.Bones[j]
				add_catrig_node bone.node bone spineindent;
				spineindent = spineindent + 1;
			)
			-- recurse down to the next hub
			recurseCATRig spine.tiphub spineindent
		)
	)
	fn addCATRigToListView =
	(
	--	lvCATRig.listItems.Clear()
		lvops.ClearLvItems lvCATRig;
		if(catparent != undefined and catparent.roothub != undefined) then 
		(
			-- Look for an existing Mapping Layer
			try
			(
				catparent.layers.controller[catparent.selectedlayer].mappinglayerDataDef;
				targetLayerInfo = catparent.layers.controller[catparent.selectedlayer].controller;
				targetLayerName = substring targetLayerInfo.layername 1 (targetLayerInfo.layername-7)
			)
			catch	(	)
		
		--	if catparent.layers.controller.selectedlayer>0 and catparent.layers.controller[catparent.layers.controller.selectedlayer].LayerType=="mocap" then
		--		 targetLayerInfo = catparent.layers.controller[catparent.layers.controller.selectedlayer];
		--	else targetLayerInfo = undefined;
			
			recurseCATRig catparent.roothub 0
			
			btnCapture.enabled = true
			btnTargetRig.text = catparent.catname;
		)
	)

	-------------------------------------------------------------------------------------------
	-- Update functions
	-------------------------------------------------------------------------------------------	
	fn updateSource = 	
	(
		setWaitCursor()		
	--	lvSource.listItems.clear();
		lvops.ClearLvItems lvSource;
		addNodesToListView lvSource source_nodes recurse:true
		setArrowCursor()
	)	
	fn Refresh =
	(
		btnCapture.enabled = (targetLayerInfo!=undefined); 
		btnAutoMap.enabled = (source_nodes!=undefined);
		btnClearMapping.enabled = (targetLayerInfo!=undefined); 
		btnLoadMapping.enabled = (catparent!=undefined);
		btnSaveMapping.enabled = (targetLayerInfo!=undefined);
	)

	
	-------------------------------------------------------------------------------------------
	-- File I/O Stuff
	-------------------------------------------------------------------------------------------	
	fn WriteData label data = (
		format "%:%\n" label data to:map_stream
	)
	fn saveMapping filename =
	(
		if (catparent==undefined) then(
			return OK;
		)
		
		map_stream = createFile filename
		
		setWaitCursor();
		
		catparent.SelectedLayer = targetLayerInfo.layerindex;
		
		format "[Header]\n" to:map_stream
		WriteData ~VERSION~ catparent.CATVersion
		WriteData ~RIGNAME~ catparent.catname
		WriteData ~WRITEDATA_FREQUENCY~ spnFreq.value
 	--	WriteData "InheritRootOffset" chkInheritRoot.checked
 
		local catnamelength = catparent.catname.count
		
		format "[Data]\n" to:map_stream;
	--	for li in lvCATRig.listItems do
		local items = (lvops.GetLvItems lvCATRig), item_count = items.count;
		for i = 1 to item_count do
		(		
			local li = items[i];--, si = li.listSubItems[merge_col]
			
		--	local si = getIndexedProperty li #subItems capture_col
			local si = lvops.GetLvItemName lvCATRig (i-1) capture_col;
			
			if li.tag!=undefined and si != undefined and si != "" then
			(
				local catNode = li.tag.value;
				local address = catNode[3].controller.address;
				local offset = catNode[3].layertrans[targetLayerInfo.layerindex].controller.offset;
				format "%=\"%\" %\n" address si offset to:map_stream
			)
		)
		
		close map_stream
		setArrowCursor()
	)
	
	
	fn loadMapping filename =
	(
		if (catparent==undefined) or not (doesFileExist filename) then return false;
		map_stream = openFile filename 
		
		local panel = getCommandPanelTaskMode();
		setCommandPanelTaskMode mode:#display
		
		if targetLayerInfo != undefined then(
			SetStatus ~SETSTATUS_CLEARING_OLD_MAPPING~	
			rCATRigMapping.ClearAllMapping();	
		)else(
			catparent.AppendLayer ((getfilenamefile filename)+~FILENAME_MAPPING~) #Absolute
			targetLayerInfo = catparent.layers.controller[catparent.selectedlayer].controller
			custAttributes.add targetLayerInfo mappinglayerData #unique		
		)
		local lvItems = lvops.GetLvItems lvCATRig;
		local num_lines, ln=0, src_file , catparentname, temp_catparent, li_index=1
		seek map_stream 0
		
		setWaitCursor()
		SetStatus ~LOADING_MAPPING_FILE~		
		local section = -1;	
		local valuearray;

		while not eof map_stream do
		(
			local line = readLine map_stream;
			if(section != 1)then(
				if(line=="[Header]") then(
					section = 0;
					continue;
				)
				if(line=="[Data]") then(
					section = 1;
					continue;
				)
				if (section == -1) then(
					-----------------------------------------------------------------------------
					-- this is legacy code so that the newer capture animation can load old files
					line_stream = line as StringStream
					-- we don't really use this
					local catparentname = readValue line_stream
					local catparenthandle = readValue line_stream
					if catparent == undefined then
					(
						catparent = (execute ("$" + catparentname))
						if catparent == undefined then
						(
							MessageBox ~PICK_CHARACTER_CAPTURE_ANIMATION_ONTO~;
							return 0;
						)
						addCATRigToListView()
					)
					section = 1
					continue;
					-----------------------------------------------------------------------------
				)
				valuearray = FilterString line ":"
				if(valuearray.count > 1)then(
					case (valuearray[1]) of(
						~RIGNAME_CAPTION~:(
							if catparent == undefined then
							(
						 		catparent = GetCATParent (execute ("$" + valuearray[2]));
								if catparent == undefined then
								(
									MessageBox ~MSGBOX_PICK_CHARACTER_CAPTURE_ANIMATION_ONTO~;
									return 0;
								)
								addCATRigToListView()
							)
						)
						~SPNFREQ_FREQUENCY~: 	spnFreq.value = (valuearray[2] as number);
					--	"InheritRootOffset": chkInheritRoot.checked = (execute valuearray[2])
						~VERSION_CASE~:
						(			
							version = (valuearray[2] as number);
						--	if (version<2400) then chkInheritRoot.checked = false;
						--	else if(version>2400 and version<2440) then chkInheritRoot.checked = true;
						)
					)
				)
			)
			else(
				local address_end = FindString line "=";
				if address_end==undefined then continue;
				local address = SubString line 1 (address_end-1);
				-- trim off the address 
				line = SubString line (address_end+1) -1;
				
				local catnode = catparent.GetBoneByAddress address;
				
				if address_end==undefined or catnode==undefined  then continue;
				
				local source_node_end = FindString line "(matrix3";
				if source_node_end==undefined then continue;
				local source_node_name = SubString line 2 (source_node_end-4);
				-- Node: getNodeByName is broken in Max9, 
				-- so I had to figure out a hack to get around it. 
				local source_node = undefined;
				local source_nodes = execute ("$'*" + source_node_name + "*'") as array
			--	local source_nodes = getNodeByName source_node_name exact:false ignoreCase:false all:true;
				for node in source_nodes do(
					if node.name == source_node_name and node != catnode then( 
						source_node = node;
						break;
					)
				)
				if source_node == undefined then continue;
				
				
				-- extract out the matrix
				line = SubString line source_node_end -1;
				local offset_tm = execute line
				
				if source_node != undefined and catnode != undefined then
				(
					local liindex = rCATRigMapping.FindCATNode catnode;
				--	if liindex!= false then 
				--	(
				--		local li = lvCATRig.listItems[liindex];
						rCATRigMapping.MapNodes source_node catnode offset_tm;
				--	--	offset_tms[liindex] = offset_tm;
						pbStatus.value = 100.0 *((liindex as float)/((lvops.GetLvItems lvCATRig).count as float))
				--	)
				)
					
				ln += 1

			--	if (mod pbStatus.value 10) == 0 then	gc() -- for every 10%, do a gc
			)
		)
		close map_stream;
		pbStatus.value = 0

		btnCapture.enabled = true;
		SetStatus ~MAPPING_FILE_LOADED~	
		catparent.catmode = 1;
		
		-- put us back on the panel we were
		setCommandPanelTaskMode mode:panel
		
		setArrowCursor()
	)
	
	fn DoCapture = 
	(
		if catparent==undefined or targetLayerInfo==undefined then(
			return OK;
		)
		SetStatus ~COLLAPSING_PRESS_ESC_TO_CANCEL~
		-- create the layer we should put the animation onto
		undo ~UNDO_CAPTURING_ANIMATION~ on
		(
			local panel = getCommandPanelTaskMode();
			setCommandPanelTaskMode mode:#display
		
		--	catparent.AppendLayer targetLayerName #Mocap
			catparent.SelectedLayer = 0;
			-- Solo the current layer
			local currentsolo = catparent.sololayer;
			catparent.sololayer = targetLayerInfo.layerindex;

			catparent.CollapseTimeRangeToLayer spnStartTime.value spnEndTime.value spnFreq.value regularplot:true;
			
			catparent.sololayer = currentsolo;
			-- put us back on the panel we were
			setCommandPanelTaskMode mode:panel
		)
		SetStatus ~FINISHED_CAPTURING~
		
		-- Once the animation has been captured, our job is finished.  Close the dialog
		destroyDialog rCaptureAnim
	)
	
	fn RegisterCallbacks =
	(
		callbacks.addScript #systemPreReset			"destroyDialog rCaptureAnim" 		id:#rCaptureAnim
		callbacks.addScript #systemPreNew			"destroyDialog rCaptureAnim"		id:#rCaptureAnim
		callbacks.addScript #filePreOpen			"destroyDialog rCaptureAnim" 		id:#rCaptureAnim
		callbacks.addScript #selectionSetChanged	"rCATRigMapping.HilightSelection()" id:#rCaptureAnim
	)
	-------------------------------------------------------------------------------------------
	-- Initialization Stuff
	-------------------------------------------------------------------------------------------


	fn UpdateSelected =
	(
		if selection.count > 0 then
			catparent = GetCATParent selection[1]

		if(catparent != undefined) then
		(
 			addCATRigToListView()
 		)
	--	EnableControls (catparent != undefined)
	)
	
	fn InitCaptureAnim quiet:false =
	(
		setWaitCursor()		
		xmlio = gxmlIO
		file_name = undefined;
		targetLayerInfo = undefined;
		dontFilterChildren = false
		addSubRollout srRollouts rCATRigMapping	rolledUp:true 		

		-- initialize various
		lvCATRig = rCATRigMapping.lvCATRig
		lvSource = rCATRigMapping.lvSource
		
		starttime = animationrange.start;
		endtime = animationrange.end;

		-- CAT first point of entry
		if not quiet then
		(
			UpdateSelected();
		
			callbacks.removeScripts id:#rCaptureAnim
			RegisterCallbacks()
			setArrowCursor()
		)
	)
		
	on rCaptureAnim open do
	(
		InitCaptureAnim();
	)
	
	on rCaptureAnim close do
	(
		if toolMode.CommandMode == #pick do toolMode.CommandMode = #move
		setIniSetting ini_file #general #position ((getDialogpos rCaptureAnim) as string)
		callbacks.removeScripts id:#rCaptureAnim
		if chkDeleteSource.checked then(
			if not quiet then (
				if (queryBox ~QUERYBOX_DELETE_SOURCE_HIERARCHY_AND_REMOVE_MAPPING_LAYER~ title:~CAPTURE_ANIMATION_CLEANUP~) then
				(
					undo ~UNDO_CAPTURE_ANIMATION_CLEANUP~ on(
						rCATRigMapping.DeleteAllSourceNodes();
					)
				)
			)else(
				rCATRigMapping.DeleteAllSourceNodes();
			)
		)
	)
	-------------------------------------------------------------------------------------------
	-- UI options events
	-------------------------------------------------------------------------------------------	

	on btnLoadMapping pressed do
	( 
		local lastfileloaded = getIniSetting ini_file "Files" "LastFileLoaded"
		if(lastfileloaded.count == 0)then lastfileloaded = ((getDir #plugcfg_ln) + "\\CAT\\rig.cam")
		
		local f = getOpenFileName caption:~OPEN_CAPTURE_ANIMATION_MAPPING_CAPTION~ types:~CAM_FILES_TYPES~ \
			filename:lastfileloaded
			
		if f != undefined then
		(
			loadMapping f;
			setIniSetting ini_file "Files" "LastFileLoaded" f
			setStatus ~SETSTATUS_MAPPING_FILE_LOADED~
		)
		Refresh(); 
	)
	on btnSaveMapping pressed do 
	( 
		local lastfilesaved = getIniSetting ini_file "Files" "LastFileSaved"
		if(lastfilesaved.count == 0)then
		(
			lastfilesaved = getIniSetting ini_file "Files" "LastFileLoaded"
			if(lastfilesaved.count == 0)then
				lastfilesaved = ((getDir #plugcfg_ln) + "\\CAT\\rig.cam")
		)

		local f = getSaveFileName caption:~SAVE_CAPTURE_ANIMATION_MAPPING~ types:~SAVE_CAM_FILES_TYPES~ \
			filename:lastfilesaved
		if f != undefined then
		(
			saveMapping f
			setIniSetting ini_file "Files" "LastFileLoaded" f
		)	
		Refresh(); 	
	)
	
	-------------------------------------------------------------------------------------------
	-- Do the animation merging/replacing
	-------------------------------------------------------------------------------------------
	on btnTargetRig picked obj do
	(
		catparent = GetCATParent obj;
		addCATRigToListView();
		Refresh(); 
	)
	
	on btnSourceObj picked obj do
	(
	--	lvSource.listItems.Clear()
		lvops.ClearLvItems lvSource
		targetLayerName = obj.name;
		btnSourceObj.text = obj.name;
	--	if source_nodes==undefined then 
		source_nodes=#(obj)
		addNodesToListView lvSource source_nodes
		Refresh(); 
 	)	
	
	on btnCapture pressed do
	(
		DoCapture();
	)
	
	on btnAutoMap pressed do 
	(
		if rCATRigMapping.AutoMap() == ok then
		(
			rCaptureAnim.setStatus ~AUTOMAP_COMPLETED~
			rCaptureAnim.setProgress 0
		)else(
			rCaptureAnim.setStatus ~AUTOMAP_FAILED~
			rCaptureAnim.setProgress 0
		)
		Refresh(); 
	)
	on btnClearMapping pressed do 
	(
		rCATRigMapping.ClearAllMapping(); 
		Refresh(); 
	)	
	
	fn ResetSpinnerRanges =
	(
		spnStartTime.range = [-99999, spnEndTime.value, spnStartTime.value]
		spnEndTime.range = [spnStartTime.value, 99999, spnEndTime.value]
	)
	on spnStartTime entered do 	ResetSpinnerRanges();
	on spnEndTime entered do	ResetSpinnerRanges();
	
	fn openDialog quiet:false = 
	(
		gc();
		local pos = execute (getIniSetting ini_file #general #position)
		if pos == ok then pos = [100, 100]
		
		targetLayerInfo = undefined;
		
		-- this will pop up a bare bone dialoge with isbasicly just the progress bar
		if quiet then
		(
			CreateDialog rCaptureAnim width:620 height:30 escapeEnable:false lockHeight:true lockWidth:true style:#(#style_border, #style_sunkenedge)
		--	grpFile.visible = false;
			chkDeleteSource.visible = false;
			btnSourceObj.visible = false;
			btnTargetRig.visible = false; 
			btnCapture.visible = false; 
			grpSource.visible = false; 
			grpMapping.visible = false;
			btnLoadMapping.visible = false; 
			btnSaveMapping.visible = false; 
			
			spnStartTime.visible = false; 
			spnEndTime.visible = false; 
			spnFreq.visible = false; 
			pbStatus.visible = false; 
			
			rCaptureAnim.quiet = quiet;
			
		--	grpMoreAttribs.visible = false; 
		--	lblRot.visible = false;
		--	spnOffsetRotX.visible = false; spnOffsetRotY.visible = false; spnOffsetRotZ.visible = false; spnOffsetPosX.visible = false; spnOffsetPosY.visible = false; spnOffsetPosZ.visible = false; 
--			srRollouts.visible = false;
--			statusBar.pos = [10, 5]
			lblStatus.pos = [5, 5]
		--	pbStatus.pos = [130, 5]
		)
		else
		(
			createDialog rCaptureAnim pos:pos style:#(#style_border, #style_titlebar, #style_minimizebox, #style_sysmenu) escapeEnable:false;
			rCaptureAnim.Refresh(); 
		)
		ResetSpinnerRanges();
	)
)


-- this function is for commandline driven capturing of data
-- it is also called by other scripts such as the ImportBVH script
fn CaptureAnimation catparentnode source_hierarchy_root camfile:undefined quiet:false delsrc:false StartTime:0 EndTime:100 layername:"" = 
(		
	rCaptureAnim.openDialog quiet:quiet;
	
	rCaptureAnim.spnStartTime.value = StartTime;
	rCaptureAnim.spnEndTime.value = EndTime;
	
	rCaptureAnim.catparent = catparentnode;
	rCaptureAnim.addCATRigToListView();
	
	rCaptureAnim.source_nodes = #(source_hierarchy_root);
	rCaptureAnim.updateSource();
	
	if layername.count > 0 then
		rCaptureAnim.targetLayerName = layername;
	else if source_hierarchy_root != undefined then
		rCaptureAnim.targetLayerName = source_hierarchy_root.name;
		
	if quiet then
	(
		try(
			rCaptureAnim.chkDeleteSource.checked = delsrc;	
			
			rCaptureAnim.targetLayerInfo = undefined;		

			if camfile != undefined and (doesFileExist camfile) then
			(
				rCaptureAnim.loadMapping camfile;
				rCaptureAnim.DoCapture();
			)else(
				DestroyDialog rCaptureAnim;	
				MessageBox ~PLEASE_SPECIFY_A_CAM_FILE~
				return false;
			)
			
		)catch(
			DestroyDialog rCaptureAnim;	
			return false;
		)
		DestroyDialog rCaptureAnim;	
		return true;
	)
	else
	(
		rCaptureAnim.chkDeleteSource.checked = delsrc;
			
		if source_hierarchy_root != undefined then
		(
			try(
				if camfile != undefined and (doesFileExist camfile) then
					 rCaptureAnim.loadMapping camfile;
				else rCATRigMapping.AutoMap();
			)catch ( rCATRigMapping.AutoMap(); )
		)
		rCaptureAnim.Refresh(); 
	)
)

-- setIniSetting riggingini "RCMenus" "MapBone" "true"


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQAjnD5RMgjxgf5pimPPlEBMMiXstb9nL/0F
-- GhRAyp3343CgTLrtOkcLY2UZcTDn3em0CrBtAQWA0hKN4pVw1z3xVsPldJ8AyyF6
-- 3HIkgsmY2rGJZKuiHlKN8nFdzk7H6eN4cUh+knxOB/92ggWsCZSD9S+IK+PzGgUT
-- RSnDmz0nqu81dDXmCXwfOL/TsRGZZJnTxwopk937PEJ7AssKkFaE/1klHwCbkist
-- gaA7699B7vC0sbk2RsYFWcEGBijeRQpjqkzk8Vqi6/NgmcBtSwV5mv4RcBcv6tZa
-- qRkS4UAXYko+uNk6k/t8Qv1mH6VhpyF4FLqOIWf+PWFI+6tordRM
-- -----END-SIGNATURE-----